<?php $__env->startSection('title', __('GSTR-1')); ?>

<?php $__env->startSection('content'); ?>

    <!-- Content Header (Page header) -->
    <section class="content-header">
        <h1><?php echo e(__('GSTR-1'), false); ?></h1>
    </section>

    <!-- Main content -->
    <section class="content">
        <div class="row">
            <div class="col-md-12">
                <table class="table">
                    <?php $__currentLoopData = $business_details; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tbody>
                            <tr>
                                <th scope="row" class="gst_report">GSTIN</th>
                                <td><?php echo e($item->tax_number_1, false); ?></td>
                                <td class="gst_report_line_2">Financial Year</td>
                                <td>
                                    <select class="form-select">
                                        <option selected>2023-2024</option>
                                        <option>2024-Continue</option>
                                    </select>
                                </td>
                                <td colspan="2" rowspan="2" class="gst_report">Sheet Status:</td>
                                <td colspan="2" rowspan="2">Active</td>
                            </tr>
                            <tr>
                                <th scope="row" class="gst_report">Legal name of the registered person</th>
                                <td><?php echo e($item->name, false); ?></td>
                                <td class="gst_report_line_2">Month</td>
                                <td>
                                    <select class="form-select" id="monthSelect">
                                        <option value="1" <?php echo e(Request::input('month') == 1 ? 'selected' : '', false); ?>>January
                                        </option>
                                        <option value="2" <?php echo e(Request::input('month') == 2 ? 'selected' : '', false); ?>>February
                                        </option>
                                        <option value="3" <?php echo e(Request::input('month') == 3 ? 'selected' : '', false); ?>>March
                                        </option>
                                        <option value="4" <?php echo e(Request::input('month') == 4 ? 'selected' : '', false); ?>>April
                                        </option>
                                        <option value="5" <?php echo e(Request::input('month') == 5 ? 'selected' : '', false); ?>>May
                                        </option>
                                        <option value="6" <?php echo e(Request::input('month') == 6 ? 'selected' : '', false); ?>>June
                                        </option>
                                        <option value="7" <?php echo e(Request::input('month') == 7 ? 'selected' : '', false); ?>>July
                                        </option>
                                        <option value="8" <?php echo e(Request::input('month') == 8 ? 'selected' : '', false); ?>>August
                                        </option>
                                        <option value="9" <?php echo e(Request::input('month') == 9 ? 'selected' : '', false); ?>>
                                            September</option>
                                        <option value="10" <?php echo e(Request::input('month') == 10 ? 'selected' : '', false); ?>>
                                            October</option>
                                        <option value="11" <?php echo e(Request::input('month') == 11 ? 'selected' : '', false); ?>>
                                            November</option>
                                        <option value="12" <?php echo e(Request::input('month') == 12 ? 'selected' : '', false); ?>>
                                            December</option>
                                    </select>
                                </td>
                            </tr>
                        </tbody>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </table>
                <table class="table">
                    <thead>
                        <tr>
                            <th colspan="18" class="table_3">
                                <span class="Hedding_text"><?php echo e($item->name, false); ?></span></br>
                                <span>0, NR. SHEETAL GUEST HOUSE, Hotel Shital</span><br />
                                <span>OUTSIDE CHIRAI NAKA, Bhachau, Kachchh, Gujarat, 370140</span><br />
                                <span class="gst_text_set">GSTIN No.:<?php echo e($item->tax_number_1, false); ?></span>
                            </th>
                        </tr>
                    </thead>
                    <tbody>
                        <tr class="gstr_1_head">
                            <th colspan="6" class="dateSet" id="dateSet">From Date DD/MM/YYYY To DD/MM/YYYY</th>
                        </tr>
                        <tr class="gstr_1_head">
                            <th>Description</th>    
                            <td>IGST Amount</td>
                            <td>CGST Amount</td>
                            <td>SGST Amount</td>
                            <td>GST Total</td>
                        </tr>
                        <tr class="gstr_1_head">
                            <th>Taxable outward supplies made to registered persons (including UIN-holders)</th>
                            <td><?php echo e($totalIGST, false); ?></td>
                            <td><?php echo e($totalCGST, false); ?></td>
                            <td><?php echo e($totalSGST, false); ?></td>
                            <td><?php echo e($totalSum, false); ?></td>
                        </tr>
                        <tr class="gstr_1_head">
                            <?php
                            $total = 0;
                            foreach($Final_GST_Total as $record) {
                                $total += $record->final_total;
                            }
                            ?>
                            <th>Taxable outward inter-State supplies to un-registered persons where the invoice value is more than Rs 2.5 lakh</th>
                            <td><?php echo e($total, false); ?></td>
                            <td class="back_red"></td>
                            <td class="back_red"></td>
                            <td><?php echo e($total, false); ?></td>
                        </tr>
                        <tr class="gstr_1_head">
                            <th>Zero rated supplies and Deemend Exports</th>
                            <td><?php echo e($totalIGSTWithoutTaxable, false); ?></td>
                            <td><?php echo e($totalCGSTWithoutTaxable, false); ?></td>
                            <td><?php echo e($totalSGSTWithoutTaxable, false); ?></td>
                            <td><?php echo e($totalSumWithoutTaxable, false); ?></td>
                        </tr>
                        <tr class="gstr_1_head">
                            <th>Taxable outward supplies to consumer</th>
                            <td></td>
                            <td></td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr class="gstr_1_head">
                            <th>Nil rated, Exempted and non GST outward supplies</th>
                            <td><?php echo e($totalIGSTWithoutTaxable, false); ?></td>
                            <td><?php echo e($totalCGSTWithoutTaxable, false); ?></td>
                            <td><?php echo e($totalSGSTWithoutTaxable, false); ?></td>
                            <td><?php echo e($totalSumWithoutTaxable, false); ?></td>
                        </tr>
                        <tr class="gstr_1_head">
                            <th>Details of Credit/Debit Notes and Refund Voucher</th>
                            <td><?php echo e($totalIGSTWithoutTaxableFinal, false); ?></td>
                            <td><?php echo e($totalCGSTWithoutTaxableFinal, false); ?></td>
                            <td><?php echo e($totalSGSTWithoutTaxableFinal, false); ?></td>
                            <td><?php echo e($totalSumWithoutTaxableFinal, false); ?></td>
                        </tr>
                        <tr class="gstr_1_head">
                            <th>Details of Credit/Debit Notes and Refund Voucher (Unregistered)</th>
                            <td><?php echo e($UnRegisterTotalIgst, false); ?></td>
                            <td><?php echo e($UnRegisterTotalCgst, false); ?></td>
                            <td><?php echo e($UnRegisterTotalCgst, false); ?></td>
                            <td><?php echo e($UnRegisterTotal, false); ?></td>
                        </tr>
                        <tr class="gstr_1_head">
                            <th>Consolidated Statement of Advances Received	</th>
                            <td></td>
                            <td></td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr class="All_Other_itc">
                            <th>Tax already paid (on advance receipt) on invoices issued in the current period</th>
                            <td></td>
                            <td></td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr class="All_Other_itc">
                            <th>HSN-wise summary of outward supplies </th>
                            <td id="total_td_1"></td>
                            <td id="total_td_2"></td>
                            <td id="total_td_3"></td>
                            <td id="total_td_4"></td>
                        </tr>
                    </tbody>
                </table>
            </div>
        </div>
    </section>
    <!-- /.content -->

<?php $__env->stopSection(); ?>

<?php $__env->startSection('javascript'); ?>
    <script src="<?php echo e(asset('js/report.js?v=' . $asset_v), false); ?>"></script>
    <script>
    // Get all <td> elements above and calculate the total
    var total1 = 0;
    var total2 = 0;
    var total3 = 0;
    var total4 = 0;

    $('table tbody tr:not(.total_row)').each(function() {
        total1 += parseFloat($(this).find('td:nth-child(1)').text()) || 0;
        total2 += parseFloat($(this).find('td:nth-child(2)').text()) || 0;
        total3 += parseFloat($(this).find('td:nth-child(3)').text()) || 0;
        total4 += parseFloat($(this).find('td:nth-child(4)').text()) || 0;
    });

    // Display the totals in respective <td> elements
    $('#total_td_1').text(total1.toFixed(2));
    $('#total_td_2').text(total2.toFixed(2));
    $('#total_td_3').text(total3.toFixed(2));
    $('#total_td_4').text(total4.toFixed(2));
</script>
    <script>
        document.getElementById('monthSelect').addEventListener('change', function() {
            var selectedMonth = this.value;
            var baseUrl = "/reports/gstr-1";
            var url = baseUrl + "?month=" + encodeURIComponent(selectedMonth.toLowerCase());
            window.location.href = url;
        });
        function updateDateRange() {
        var month = document.getElementById("monthSelect").value;
        var year = new Date().getFullYear();
        var startDate = new Date(year, month - 1, 1);
        var endDate = new Date(year, month, 0); 

        var startDateFormatted = startDate.getDate() + '/' + (startDate.getMonth() + 1) + '/' + startDate.getFullYear();
        var endDateFormatted = endDate.getDate() + '/' + (endDate.getMonth() + 1) + '/' + endDate.getFullYear();

        document.getElementById("dateSet").innerHTML = "From Date " + startDateFormatted + " To " + endDateFormatted;
    }

    updateDateRange();

    document.getElementById("monthSelect").addEventListener("change", updateDateRange);
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/aror4382/eway-einvoice.netbas.in/resources/views/report/Gstr_1.blade.php ENDPATH**/ ?>