@extends('layouts.app')
@section('title', __('GSTR-3B'))

@section('content')

    <!-- Content Header (Page header) -->
    <section class="content-header">
        <h1>{{ __('GSTR-3B') }}</h1>
    </section>

    <!-- Main content -->
    <section class="content">
        <div class="row">
            <div class="col-md-12">
                <table class="table">
                    @foreach ($business_details as $item)
                        <tbody>
                            <tr>
                                <th scope="row" class="gst_report">GSTIN</th>
                                <td>{{ $item->tax_number_1 }}</td>
                                <td class="gst_report_line_2">Financial Year</td>
                                <td>
                                    <select class="form-select">
                                        <option selected>2023-2024</option>
                                        <option>2024-Continue</option>
                                    </select>
                                </td>
                                <td colspan="2" rowspan="2" class="gst_report">Sheet Status:</td>
                                <td colspan="2" rowspan="2">Active</td>
                            </tr>
                            <tr>
                                <th scope="row" class="gst_report">Legal name of the registered person</th>
                                <td>{{ $item->name }}</td>
                                <td class="gst_report_line_2">Month</td>
                                <td>
                                    <select class="form-select" id="monthSelect">
                                        <option value="1" {{ Request::input('month') == 1 ? 'selected' : ''}}>January</option>
                                        <option value="2" {{ Request::input('month') == 2 ? 'selected' : '' }}>February</option>
                                        <option value="3" {{ Request::input('month') == 3 ? 'selected' : '' }}>March</option>
                                        <option value="4" {{ Request::input('month') == 4 ? 'selected' : '' }}>April</option>
                                        <option value="5" {{ Request::input('month') == 5 ? 'selected' : '' }}>May</option>
                                        <option value="6" {{ Request::input('month') == 6 ? 'selected' : '' }}>June</option>
                                        <option value="7" {{ Request::input('month') == 7 ? 'selected' : '' }}>July</option>
                                        <option value="8" {{ Request::input('month') == 8 ? 'selected' : '' }}>August</option>
                                        <option value="9" {{ Request::input('month') == 9 ? 'selected' : '' }}>September</option>
                                        <option value="10" {{ Request::input('month') == 10 ? 'selected' : '' }}>October</option>
                                        <option value="11" {{ Request::input('month') == 11 ? 'selected' : '' }}>November</option>
                                        <option value="12" {{ Request::input('month') == 12 ? 'selected' : '' }}>December</option>
                                    </select>
                                </td>
                            </tr>
                        </tbody>
                    @endforeach
                </table>

                <table class="table">
                    <thead>
                        <tr>
                            <th colspan="6" class="table_2">
                                3.1 Details of Outward Supplies and inward supplies liable to reverse charge
                            </th>
                        </tr>
                    </thead>
                    <tbody>
                        <tr class="table_2_head">
                            <th>Nature of Supplies</th>
                            <td>Total Taxable value</td>
                            <td>Integrated Tax</td>
                            <td>Central Tax</td>
                            <td>State/UT Tax</td>
                            <td>Cess</td>
                        </tr>
                        <tr class="table_2_head_3">
                            <th>1</th>
                            <td>2</td>
                            <td>3</td>
                            <td>4</td>
                            <td>5</td>
                            <td>6</td>
                        </tr>
                        <tr>
                            <th>(a) Outward Taxable supplies (other than zero rated, nil rated and exempted)</th>
                            <td class="Rs_Section">{{ $totalSum }}</td>
                            <td class="Rs_Section">{{ $totalIGST }}</td>
                            <td class="Rs_Section">{{ $totalCGST }}</td>
                            <td class="Rs_Section">{{ $totalSGST }}</td>
                            <td class="Rs_Section">Rs 0</td>
                        </tr>   
                        <tr>
                            <th>(b) Outward Taxable supplies (zero rated )</th>
                            <td class="Rs_Section">{{ $totalSumWithoutTaxable }}</td>
                            <td class="table_2_head_3"></td>
                            <td class="table_2_head_3"></td>
                            <td class="Rs_Section">{{ $totalIGSTWithoutTaxable }}</td>
                            <td class="Rs_Section">Rs 0</td>
                        </tr>
                        <tr>
                            <th>(c) Other Outward Taxable supplies (Nil rated, exempted)</th>
                            <td class="Rs_Section">{{ $totalSumWithoutTaxable }}</td>
                            <td class="table_2_head_3"></td>
                            <td class="table_2_head_3"></td>
                            <td class="table_2_head_3"></td>
                            <td class="table_2_head_3"></td>
                        </tr>
                        <tr>
                            <th>(d) Inward supplies (liable to reverse charge) </th>
                            <td class="Rs_Section">Rs 0</td>
                            <td class="Rs_Section">Rs 0</td>
                            <td class="Rs_Section">Rs 0</td>
                            <td class="Rs_Section">Rs 0</td>
                            <td class="Rs_Section">Rs 0</td>
                        </tr>
                        <tr>
                            <th>(e) Non-GST Outward supplies</th>
                            <td class="Rs_Section">{{ $finalGSTTotal  }}</td>
                            <td class="table_2_head_3"></td>
                            <td class="table_2_head_3"></td>
                            <td class="table_2_head_3"></td>
                            <td class="table_2_head_3"></td>
                        </tr>
                        <tr class="total_section">
                            <th>Total</th>
                            <td>Rs 0</td>
                            <td>Rs 0</td>
                            <td>Rs 0</td>
                            <td>Rs 0</td>
                            <td>Rs 0</td>
                        </tr>
                    </tbody>
                </table>
                <table class="table">
                    <thead>
                        <tr>
                            <th colspan="6" class="table_3">
                                4. Eligible ITC
                            </th>
                        </tr>
                    </thead>
                    <tbody>
                        <tr class="table_3_head">
                            <th>Details</th>
                            <td>Integrated Tax</td>
                            <td>Central Tax</td>
                            <td>State/UT Tax</td>
                            <td>Cess</td>
                        </tr>
                        <tr class="table_3_head_3">
                            <th>1</th>
                            <td>2</td>
                            <td>3</td>
                            <td>4</td>
                            <td>5</td>
                        </tr>
                        <tr>
                            <th>(A) ITC Available (Whether in full or part)</th>
                            <td></td>
                            <td></td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <th>(1) Import of goods </th>
                            <td class="Import-of-goods">{{ $GstCount }}</td>
                            <td class="Import-of-goods-plain"></td>
                            <td class="Import-of-goods-plain"></td>
                            <td class="Import-of-goods">Rs 0</td>
                        </tr>
                        <tr>
                            <th>(2) Import of services </th>
                            <td class="Import-of-goods">Rs 0</td>
                            <td class="Import-of-goods-plain"></td>
                            <td class="Import-of-goods-plain"></td>
                            <td class="Import-of-goods">Rs 0</td>
                        </tr>
                        <tr>
                            <th>(3) Inward supplies liable to reverse charge
                                (other than 1 &2 above)</th>
                            <td class="Import-of-goods">Rs 0</td>
                            <td class="Import-of-goods">Rs 0</td>
                            <td class="Import-of-goods">Rs 0</td>
                            <td class="Import-of-goods">Rs 0</td>
                        </tr>
                        <tr>
                            <th>(4) Inward supplies from ISD</th>
                            <td class="Import-of-goods">Rs 0</td>
                            <td class="Import-of-goods">Rs 0</td>
                            <td class="Import-of-goods">Rs 0</td>
                            <td class="Import-of-goods">Rs 0</td>
                        </tr>
                        <tr>
                            <th>(5) All other ITC</th>
                            <td class="Import-of-goods">Rs 0</td>
                            <td class="Import-of-goods">Rs 0</td>
                            <td class="Import-of-goods">Rs 0</td>
                            <td class="Import-of-goods">Rs 0</td>
                        </tr>
                        <tr>
                            <th> (B) ITC Reversed</th>
                            <td></td>
                            <td></td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <th>(1) As per rules 38,42 & 43 of CGST Rules and section 17(5)</th>
                            <td class="Import-of-goods">Rs 0</td>
                            <td class="Import-of-goods">Rs 0</td>
                            <td class="Import-of-goods">Rs 0</td>
                            <td class="Import-of-goods">Rs 0</td>
                        </tr>
                        <tr>
                            <th>(2) Others</th>
                            <td class="Import-of-goods">Rs 0</td>
                            <td class="Import-of-goods">Rs 0</td>
                            <td class="Import-of-goods">Rs 0</td>
                            <td class="Import-of-goods">Rs 0</td>
                        </tr>
                        <tr class="sizeset">
                            <th> (C) Net ITC Available (A)-(B)</th>
                            <td class="text-center">Rs 0</td>
                            <td class="text-center">Rs 0</td>
                            <td class="text-center">Rs 0</td>
                            <td class="text-center">Rs 0</td>
                        </tr>
                        <tr>
                            <th> (D) Other Details</th>
                            <td></td>
                            <td></td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr>
                            <th>(1) ITC reclaimed which was reversed under Table 4(B)(2) in earlier tax period</th>
                            <td class="Import-of-goods">Rs 0</td>
                            <td class="Import-of-goods">Rs 0</td>
                            <td class="Import-of-goods">Rs 0</td>
                            <td class="Import-of-goods">Rs 0</td>
                        </tr>
                        <tr>
                            <th>(2) Ineligible ITC under section 16(4) & ITC restricted due to PoS rules</th>
                            <td class="Import-of-goods">Rs 0</td>
                            <td class="Import-of-goods">Rs 0</td>
                            <td class="Import-of-goods">Rs 0</td>
                            <td class="Import-of-goods">Rs 0</td>
                        </tr>
                    </tbody>
                </table>
            </div>
        </div>
    </section>
    <!-- /.content -->

@endsection

@section('javascript')
    <script src="{{ asset('js/report.js?v=' . $asset_v) }}"></script>
    <script>
        document.getElementById('monthSelect').addEventListener('change', function() {
            var selectedMonth = this.value;
            var baseUrl = "/reports/gstr-3b";
            var url = baseUrl + "?month=" + encodeURIComponent(selectedMonth.toLowerCase());
            window.location.href = url;
        });
    </script>
@endsection
