@extends('layouts.app')
@section('title', __('GSTR-1'))

@section('content')

    <!-- Content Header (Page header) -->
    <section class="content-header">
        <h1>{{ __('GSTR-1') }}</h1>
    </section>

    <!-- Main content -->
    <section class="content">
        <div class="row">
            <div class="col-md-12">
                <table class="table">
                    @foreach ($business_details as $item)
                        <tbody>
                            <tr>
                                <th scope="row" class="gst_report">GSTIN</th>
                                <td>{{ $item->tax_number_1 }}</td>
                                <td class="gst_report_line_2">Financial Year</td>
                                <td>
                                    <select class="form-select">
                                        <option selected>2023-2024</option>
                                        <option>2024-Continue</option>
                                    </select>
                                </td>
                                <td colspan="2" rowspan="2" class="gst_report">Sheet Status:</td>
                                <td colspan="2" rowspan="2">Active</td>
                            </tr>
                            <tr>
                                <th scope="row" class="gst_report">Legal name of the registered person</th>
                                <td>{{ $item->name }}</td>
                                <td class="gst_report_line_2">Month</td>
                                <td>
                                    <select class="form-select" id="monthSelect">
                                        <option value="1" {{ Request::input('month') == 1 ? 'selected' : '' }}>January
                                        </option>
                                        <option value="2" {{ Request::input('month') == 2 ? 'selected' : '' }}>February
                                        </option>
                                        <option value="3" {{ Request::input('month') == 3 ? 'selected' : '' }}>March
                                        </option>
                                        <option value="4" {{ Request::input('month') == 4 ? 'selected' : '' }}>April
                                        </option>
                                        <option value="5" {{ Request::input('month') == 5 ? 'selected' : '' }}>May
                                        </option>
                                        <option value="6" {{ Request::input('month') == 6 ? 'selected' : '' }}>June
                                        </option>
                                        <option value="7" {{ Request::input('month') == 7 ? 'selected' : '' }}>July
                                        </option>
                                        <option value="8" {{ Request::input('month') == 8 ? 'selected' : '' }}>August
                                        </option>
                                        <option value="9" {{ Request::input('month') == 9 ? 'selected' : '' }}>
                                            September</option>
                                        <option value="10" {{ Request::input('month') == 10 ? 'selected' : '' }}>
                                            October</option>
                                        <option value="11" {{ Request::input('month') == 11 ? 'selected' : '' }}>
                                            November</option>
                                        <option value="12" {{ Request::input('month') == 12 ? 'selected' : '' }}>
                                            December</option>
                                    </select>
                                </td>
                            </tr>
                        </tbody>
                    @endforeach
                </table>
                <table class="table">
                    <thead>
                        <tr>
                            <th colspan="18" class="table_3">
                                <span class="Hedding_text">{{ $item->name }}</span></br>
                                <span>0, NR. SHEETAL GUEST HOUSE, Hotel Shital</span><br />
                                <span>OUTSIDE CHIRAI NAKA, Bhachau, Kachchh, Gujarat, 370140</span><br />
                                <span class="gst_text_set">GSTIN No.:{{ $item->tax_number_1 }}</span>
                            </th>
                        </tr>
                    </thead>
                    <tbody>
                        <tr class="gstr_1_head">
                            <th colspan="6" class="dateSet" id="dateSet">From Date DD/MM/YYYY To DD/MM/YYYY</th>
                        </tr>
                        <tr class="gstr_1_head">
                            <th>Description</th>    
                            <td>IGST Amount</td>
                            <td>CGST Amount</td>
                            <td>SGST Amount</td>
                            <td>GST Total</td>
                        </tr>
                        <tr class="gstr_1_head">
                            <th>Taxable outward supplies made to registered persons (including UIN-holders)</th>
                            <td>{{ $totalIGST }}</td>
                            <td>{{ $totalCGST }}</td>
                            <td>{{ $totalSGST }}</td>
                            <td>{{ $totalSum }}</td>
                        </tr>
                        <tr class="gstr_1_head">
                            @php
                            $total = 0;
                            foreach($Final_GST_Total as $record) {
                                $total += $record->final_total;
                            }
                            @endphp
                            <th>Taxable outward inter-State supplies to un-registered persons where the invoice value is more than Rs 2.5 lakh</th>
                            <td>{{ $total }}</td>
                            <td class="back_red"></td>
                            <td class="back_red"></td>
                            <td>{{ $total }}</td>
                        </tr>
                        <tr class="gstr_1_head">
                            <th>Zero rated supplies and Deemend Exports</th>
                            <td>{{ $totalIGSTWithoutTaxable }}</td>
                            <td>{{ $totalCGSTWithoutTaxable }}</td>
                            <td>{{ $totalSGSTWithoutTaxable }}</td>
                            <td>{{ $totalSumWithoutTaxable }}</td>
                        </tr>
                        <tr class="gstr_1_head">
                            <th>Taxable outward supplies to consumer</th>
                            <td></td>
                            <td></td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr class="gstr_1_head">
                            <th>Nil rated, Exempted and non GST outward supplies</th>
                            <td>{{ $totalIGSTWithoutTaxable }}</td>
                            <td>{{ $totalCGSTWithoutTaxable }}</td>
                            <td>{{ $totalSGSTWithoutTaxable }}</td>
                            <td>{{ $totalSumWithoutTaxable }}</td>
                        </tr>
                        <tr class="gstr_1_head">
                            <th>Details of Credit/Debit Notes and Refund Voucher</th>
                            <td>{{ $totalIGSTWithoutTaxableFinal  }}</td>
                            <td>{{ $totalCGSTWithoutTaxableFinal  }}</td>
                            <td>{{ $totalSGSTWithoutTaxableFinal  }}</td>
                            <td>{{ $totalSumWithoutTaxableFinal  }}</td>
                        </tr>
                        <tr class="gstr_1_head">
                            <th>Details of Credit/Debit Notes and Refund Voucher (Unregistered)</th>
                            <td>{{ $UnRegisterTotalIgst }}</td>
                            <td>{{ $UnRegisterTotalCgst }}</td>
                            <td>{{ $UnRegisterTotalCgst }}</td>
                            <td>{{ $UnRegisterTotal }}</td>
                        </tr>
                        <tr class="gstr_1_head">
                            <th>Consolidated Statement of Advances Received	</th>
                            <td></td>
                            <td></td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr class="All_Other_itc">
                            <th>Tax already paid (on advance receipt) on invoices issued in the current period</th>
                            <td></td>
                            <td></td>
                            <td></td>
                            <td></td>
                        </tr>
                        <tr class="All_Other_itc">
                            <th>HSN-wise summary of outward supplies </th>
                            <td id="total_td_1"></td>
                            <td id="total_td_2"></td>
                            <td id="total_td_3"></td>
                            <td id="total_td_4"></td>
                        </tr>
                    </tbody>
                </table>
            </div>
        </div>
    </section>
    <!-- /.content -->

@endsection

@section('javascript')
    <script src="{{ asset('js/report.js?v=' . $asset_v) }}"></script>
    <script>
    // Get all <td> elements above and calculate the total
    var total1 = 0;
    var total2 = 0;
    var total3 = 0;
    var total4 = 0;

    $('table tbody tr:not(.total_row)').each(function() {
        total1 += parseFloat($(this).find('td:nth-child(1)').text()) || 0;
        total2 += parseFloat($(this).find('td:nth-child(2)').text()) || 0;
        total3 += parseFloat($(this).find('td:nth-child(3)').text()) || 0;
        total4 += parseFloat($(this).find('td:nth-child(4)').text()) || 0;
    });

    // Display the totals in respective <td> elements
    $('#total_td_1').text(total1.toFixed(2));
    $('#total_td_2').text(total2.toFixed(2));
    $('#total_td_3').text(total3.toFixed(2));
    $('#total_td_4').text(total4.toFixed(2));
</script>
    <script>
        document.getElementById('monthSelect').addEventListener('change', function() {
            var selectedMonth = this.value;
            var baseUrl = "/reports/gstr-1";
            var url = baseUrl + "?month=" + encodeURIComponent(selectedMonth.toLowerCase());
            window.location.href = url;
        });
        function updateDateRange() {
        var month = document.getElementById("monthSelect").value;
        var year = new Date().getFullYear();
        var startDate = new Date(year, month - 1, 1);
        var endDate = new Date(year, month, 0); 

        var startDateFormatted = startDate.getDate() + '/' + (startDate.getMonth() + 1) + '/' + startDate.getFullYear();
        var endDateFormatted = endDate.getDate() + '/' + (endDate.getMonth() + 1) + '/' + endDate.getFullYear();

        document.getElementById("dateSet").innerHTML = "From Date " + startDateFormatted + " To " + endDateFormatted;
    }

    updateDateRange();

    document.getElementById("monthSelect").addEventListener("change", updateDateRange);
    </script>
@endsection
