@php
	$common_settings = session()->get('business.common_settings');
@endphp
<div class="row">
    <div class="col-md-12">
        <hr>
        <table class="table table-slim" id="stock_history_table">
            <thead>
                <tr>
                    <th>@lang('Bill No.')</th>
                    <th>@lang('Party Name')</th>
                    @if(!empty($common_settings['enable_secondary_unit']))
                        <th>@lang('lang_v1.new_quantity') (@lang('lang_v1.secondary_unit'))</th>
                    @endif
                    <th>@lang('lang_v1.date')</th>
                    <th>@lang('UID')</th>
                </tr>
            </thead>
            <tbody>
                @forelse($uid_record as $index => $custom_uid)
                    <tr>
                        <td>{{ $custom_uid->invoice_no ?? $custom_uid->ref_no }}</td>                                        
                        <td>{{ $custom_uid->supplier_business_name }}</td>                       
                        <td>{{ @format_datetime($custom_uid->transaction_date) }}</td>
                        <td>{{ $custom_uid->uid }}</td>
                    </tr>
                @empty
                    <tr>
                        <td colspan="5" class="text-center">
                            @lang('lang_v1.no_stock_history_found')
                        </td>
                    </tr>
                @endforelse
            </tbody>
        </table>
    </div>
</div>

