<div class="pos-tab-content">
    <div class="row">
        <div class="col-sm-4">
            <div class="form-group">
                {!! Form::label('stock_expiry_alert_days', __('business.view_stock_expiry_alert_for') . ':*') !!}
                <div class="input-group">
                    <span class="input-group-addon">
                        <i class="fas fa-calendar-times"></i>
                    </span>
                    {!! Form::number('stock_expiry_alert_days', $business->stock_expiry_alert_days, [
                        'class' => 'form-control',
                        'required',
                    ]) !!}
                    <span class="input-group-addon">
                        @lang('business.days')
                    </span>
                </div>
            </div>
        </div>
    </div>
    <div class="row">
        <div class="col-sm-2">
            <div class="form-group pull-right">
                <div class="input-group">
                    <button type="button" class="btn btn-primary" id="dashboard_date_filter">
                        <span>
                            <i class="fa fa-calendar"></i> {{ __('messages.filter_by_date') }}
                        </span>
                        <i class="fa fa-caret-down"></i>
                    </button>
                </div>
            </div>
        </div>
    </div>
</div>
<script>
    $(document).ready(function() {
        var defaultStartDate = moment().startOf('month');
        var defaultEndDate = moment().endOf('month');

        $('#dashboard_date_filter').daterangepicker({
            startDate: defaultStartDate,
            endDate: defaultEndDate,
            ranges: {
                'Today': [moment(), moment()],
                'Yesterday': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
                'This Month': [moment().startOf('month'), moment().endOf('month')],
                'Last 30 Days': [moment().subtract(29, 'days'), moment()],
                'All Time': [moment('2000-01-01'), moment()]
            },
            opens: 'left'
        });
        update(defaultStartDate.format('YYYY-MM-DD'), defaultEndDate.format('YYYY-MM-DD'));
    });

    function update(start, end) {
        console.log('Updating Range:', start, 'to', end);
    }
</script>
@section('javascript')
    <script src="{{ asset('js/home.js?v=' . $asset_v) }}"></script>
@endsection
