<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        //
        Schema::create('stock_transfer', function (Blueprint $table) {
            $table->increments('id');
            $table->integer('transaction_id')->unsigned();
            $table->foreign('transaction_id')->references('id')->on('transactions')->onDelete('cascade');
            $table->integer('transaction_line_id')->unsigned();
            $table->foreign('transaction_line_id')->references('id')->on('variations')->onDelete('cascade');
            $table->integer('product_id')->unsigned();
            $table->foreign('product_id')->references('id')->on('products')->onDelete('cascade');
            $table->integer('variation_id')->unsigned();
            $table->foreign('variation_id')->references('id')->on('variations')->onDelete('cascade');
            $table->integer('uid_id')->unsigned();
            $table->foreign('uid_id')->references('id')->on('uids')->onDelete('cascade');
            $table->integer('from_location_id')->unsigned();
            $table->foreign('from_location_id')->references('id')->on('business_locations')->onDelete('cascade');
            $table->integer('to_location_id')->unsigned();
            $table->foreign('to_location_id')->references('id')->on('business_locations')->onDelete('cascade');
            $table->softDeletes();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        //
        Schema::dropIfExists('stock_transfer');
    }
};
