<?php

namespace App;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class StockTransfer extends Model
{
    use HasFactory;
    protected $primaryKey = 'id';
    protected $table = 'stock_transfer';

    public function transaction()
    {
        return $this->belongsTo(Transaction::class, 'transaction_id');
    }

    public function transactionLine()
    {
        return $this->belongsTo(Variation::class, 'transaction_line_id');
    }

    public function product()
    {
        return $this->belongsTo(Product::class, 'product_id');
    }

    public function variation()
    {
        return $this->belongsTo(Variation::class, 'variation_id');
    }

    public function uid()
    {
        return $this->belongsTo(Uid::class, 'uid_id');
    }

    public function from_location()
    {
        return $this->belongsTo(BusinessLocation::class, 'from_location_id');
    }
    
    public function to_location()
    {
        return $this->belongsTo(BusinessLocation::class, 'to_location_id');
    }
}
